// $Id: CRadioButton.cpp,v 1.5 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CRadioButton.hpp"
using Exponent::GUI::Controls::CRadioButton;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CRadioButton, CControlPanel);

//	===========================================================================
CRadioButton::CRadioButton(IControlRoot *root, const long uniqueId, const CRect &area, const long numberOfButtons, IActionListener *listener) 
			: CControlPanel(root->getParentWindow(), root, uniqueId, area, listener)
			, m_selectedIndex(0)
			, m_numberOfButtons(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CRadioButton);

	// Add the buttons..
	this->setNumberOfButtons(numberOfButtons);
	this->onDrawDrawThePanelBounds(false);
}

//	===========================================================================
CRadioButton::~CRadioButton()
{
	EXPONENT_CLASS_DESTRUCTION(CRadioButton);
}

//	===========================================================================
void CRadioButton::handleActionEvent(const CActionEvent &event)
{
	CLatchingButton *current   = (CLatchingButton *)this->getControlAtIndex(m_selectedIndex);
	CLatchingButton *theButton = (CLatchingButton *)event.getControl();

	if (current)
	{
		current->setValue(0.0);
		current->update();
	}

	if (theButton)
	{
		// The button selected should be on (even if they have turned it off (cos we cant have all buttons off)
		theButton->setValue(1.0);
	
		// Store the selected index
		m_selectedIndex = theButton->getUniqueId();
	}

	// Notify the listener
	if (m_actionListener)
	{
		m_actionListener->handleActionEvent(CActionEvent(this));
	}
}

//	===========================================================================
void CRadioButton::setSelectedButton(const long index)
{
	if (index >= 0 && index < m_numberOfButtons)
	{
		m_selectedIndex = index;
		for (long i = 0; i < m_numberOfButtons; i++)
		{
			CLatchingButton *button = (CLatchingButton *)this->getControlAtIndex(i);
			if (button)
			{
				if (i == m_selectedIndex)
				{
					button->setValue(1.0);
				}
				else
				{
					button->setValue(0.0);
				}
			}
		}
	}
}

//	===========================================================================
void CRadioButton::setNumberOfButtons(const long number)
{
	if (number > 0)
	{
		// Clear any controls we may have had
		this->clearControls();

		// Store the number of buttons that we want
		m_numberOfButtons = number;
		m_selectedIndex   = 0;

		// Add the buttons - NOTE : all in same location, you must set the positions before useage
		for (long i = 0; i < number; i++)
		{
			CLatchingButton *button = new CLatchingButton(this, i, CRect(0, 0, 10, 10), this);
			this->addControl(button);
			if (i == 0)
			{
				button->setValue(1.0);
			}
			else
			{
				button->setValue(0.0);
			}
		}
	}
}

//	===========================================================================
void CRadioButton::setArea(const CRect &area)
{
	CControlPanel::setArea(area);
}